<?php
$PageTitle = "Result";
include("./layout/header.php");

$tid = $_GET['track'];

$sql = "SELECT * FROM track WHERE pid = '$tid'";
$result = mysqli_query($link, $sql);
if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $email = $row['email'];
    $location = isset($row['location']) ? $row['location'] : '';
}
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Rubik&display=swap');

:root {
    --line-border-fill: #3498db;
    --line-border-empty: #e0e0e0;
}

.status-icon {
    font-size: 3rem;
}

@media (max-width: 768px) {
    .status-icon {
        font-size: 2.5rem;
    }
}

@media (max-width: 480px) {
    .status-icon {
        font-size: 2.5rem;
    }
}

/* ... (rest of your existing CSS styles) ... */
</style>

<!-- Start Page Title Area -->
<div class="page-title-area item-bg-1 jarallax" data-jarallax='{"speed": 0.3}'>
    <div class="container">
        <div class="page-title-content">
            <div class="row align-items-center">
                <div class="col-lg-6 col-sm-6">
                    <h2>Tracking No: <?php echo $row['pid'];?></h2>
                </div>
                <div class="col-lg-6 col-sm-6">
                    <h4></h4>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Title Area -->

<?php 
$sql = "SELECT * FROM track WHERE pid = '$tid'";
$result = mysqli_query($link, $sql);
if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $status = $row['status'];

    $icon = '';
    $color = '';
    $status_text = '';

    switch ($status) {
    case 'Arrived Warehouse':
        $icon = 'fa-warehouse fa-bounce';
        $color = '#17a2b8'; // Teal
        $status_text = 'Arrived at Warehouse';
        break;
    case 'Depart Warehouse':
        $icon = 'fa-plane-departure fa-bounce';
        $color = '#fd7e14'; // Orange
        $status_text = 'Departed from Warehouse';
        break;
    case 'processing':
        $icon = 'fa-cog fa-spin';
        $color = '#ffc107'; // Yellow
        $status_text = 'Package Processing';
        break;
    case 'In Transit':
        $icon = 'fa-truck-moving fa-spin';
        $color = '#28a745'; // Green
        $status_text = 'Package In Transit';
        break;
    case 'quality': // "Checked" in your dropdown
        $icon = 'fa-check-double fa-shake';
        $color = '#20c997'; // Light Green
        $status_text = 'Quality Checked';
        break;
    case 'dispatch':
        $icon = 'fa-truck fa-bounce';
        $color = '#007bff'; // Blue
        $status_text = 'Package Dispatched';
        break;
    case 'On-Hold': // Added this since it's in your dropdown
    case 'withheld': // Keeping for consistency
        $icon = 'fa-exclamation-triangle fa-shake';
        $color = '#dc3545'; // Red
        $status_text = 'Package On Hold';
        break;
    case 'delivered':
        $icon = 'fa-check-circle fa-beat';
        $color = '#17a2b8'; // Teal (changed for distinction)
        $status_text = 'Package Delivered';
        break;
    default:
        $icon = 'fa-question-circle fa-pulse';
        $color = '#6c757d'; // Gray
        $status_text = 'Unknown Status';
}


    $confirm = "
    <div style='text-align: center; margin-bottom: 30px;'>
        <div style='display: inline-block; background-color: {$color}; border-radius: 50%; padding: 20px; margin-bottom: 15px;'>
            <i class='fas {$icon} status-icon' style='color: white;'></i>
        </div>
        <h3>{$status_text}</h3>
        <p>" . ($status == 'withheld' ? 'Package on Hold under Custom Review' : 'Current status of your package.') . "</p>
    </div>";
}
?>

<!-- Start Track Area -->
<section class="track-area ptb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tab quote-list-tab">
                    <center><?php echo $confirm; ?></center>
                    <div class="tab_content">
                        <div class="tabs_item">
                            <form>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Shipment Dates</h3>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered" style="border: 1px yellow solid;">
                                                    <thead>
                                                        <tr>
                                                            <th>Departure Date</th>
                                                            <th>Delivery Date</th>
                                                            <th>Destination</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr style="background-color:black;color:#fff;">
                                                            <td><?php echo $row['shipdate'];?></td>
                                                            <td><?php echo $row['edd'];?></td>
                                                            <td><?php echo $row['saddress'];?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Sender Details</h3>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered" style="border: 1px yellow solid;">
                                                    <thead>
                                                        <tr>
                                                            <th>Sender Name</th>
                                                            <th>Sender Address</th>
                                                            <th>Sender Email</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr style="background-color:black;color:#fff;">
                                                            <td><?php echo $row['sname'];?></td>
                                                            <td><?php echo $row['saddress'];?></td>
                                                            <td><?php echo $row['email'];?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Receiver Details</h3>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered" style="border: 1px yellow solid;">
                                                    <thead>
                                                        <tr>
                                                            <th>Receiver Name</th>
                                                            <th>Receiver Address</th>
                                                            <th>Receiver Email</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr style="background-color:black;color:#fff;">
                                                            <td><?php echo $row['rname'];?></td>
                                                            <td><?php echo $row['raddress'];?></td>
                                                            <td><?php echo $row['remail'];?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Shipment Content/Description</h3>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>SKU Number</th>
                                                            <th>Quantity</th>
                                                            <th>Weight</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr style="background-color:black;color:#fff;">
                                                            <td>CARGO75468<?php echo $row['id'];?></td>
                                                            <td><?php echo $row['qty'];?></td>
                                                            <td><?php echo $row['weight'];?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Shipment Facts</h3>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered" style="border: 1px yellow solid;">
                                                    <thead>
                                                        <tr>
                                                            <th>Service Type</th>
                                                            <th>Content</th>
                                                            <th>Remark</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr style="background-color:black;color:#fff;">
                                                            <td><?php echo $row['servicetype'];?></td>
                                                            <td><?php echo $row['pdesc'];?></td>
                                                            <td><?php echo $row['remark'];?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12">
                                                <h3>Shipment Travel History</h3>
                                                <p>All shipment travel activities are displayed here</p> <br>
                                            </div>
                                        </div>

                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered" style="border: 1px yellow solid;">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Activities</th>
                                                        <th>Location</th>
                                                        <th>Details</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php 
                                                    $sql = "SELECT * FROM history WHERE pid = '$tid'";
                                                    $result = mysqli_query($link, $sql);
                                                    if (mysqli_num_rows($result) > 0) {
                                                        while ($row = mysqli_fetch_assoc($result)) {
                                                    ?>
                                                    <tr style="background-color:black;color:#fff;">
                                                        <td><?php echo $row['pdate'];?></td>
                                                        <td><?php echo $row['status'];?></td>
                                                        <td><?php echo $row['location'];?></td>
                                                        <td><?php echo $row['remark'];?></td>
                                                    </tr>
                                                    <?php
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <?php 
                                        $sql = "SELECT * FROM track WHERE pid = '$tid'";
                                        $result = mysqli_query($link, $sql);
                                        if (mysqli_num_rows($result) > 0) {
                                            $row = mysqli_fetch_assoc($result);
                                            $image = isset($row['image']) ? $row['image'] : '';
                                        }
                                        ?>
                                        <div class="track">
                                            <button type="button" data-toggle="modal" data-target="#myModal" class="btn btn-primary btn-arrow-right">Show Package Image</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Track Area -->

<?php
include("./layout/footer.php");
?>